#### 3.0.0 发卡问题
SELECT uc.uuid                                AS `卡ID`,
       uc.card_no                             AS `卡号`,
       uc.card_name                           AS `卡名称`,
       u.`nick_name`                          AS `持卡人`,
       s.name                                 AS `门店名称`,
       IF
       (uc.activate_type = 2, '第一次预约开发', '特定时间开卡')
                                              AS `开卡方式`,
       uc.create_time                         AS `创建时间`,
       #uc.effective_unit 有效期数值单位，1：月，2：天
       CASE uc.effective_unit
           WHEN 1 THEN '月'
           WHEN 2 THEN '天'
           ELSE '未知'
           END                                AS `发卡-有效期单位`,
       uc.effective_number                    AS `发卡-有效期数值`,
       #sc.effective_unit 有效期数值单位，1：月，2：天
       CASE sc.effective_unit
           WHEN 1 THEN '月'
           WHEN 2 THEN '天'
           ELSE '未知'
           END                                AS `会员卡名称-有效期单位`,
       sc.effective_number                    AS `会员卡名称-有效期数值`,
       DATEDIFF(uc.end_time, uc.start_time)   AS `有效天数`,
       TIMESTAMPDIFF(MONTH, uc.start_time, uc.end_time) AS `有效月数`,
         uc.update_time                         AS `更新时间`,
       uc.activate_time                       AS `开卡时间`,
       uc.start_time                          AS `开始时间`,
       uc.end_time                            AS `结束时间`,
# uc.type 1：期限卡，2：次数卡，3：储值卡
       CASE uc.type
           WHEN 1 THEN '期限卡'
           WHEN 2 THEN '次数卡'
           WHEN 3 THEN '储值卡'
           ELSE '未知'
           END                                AS `卡类型`,
# uc.operation_type 会员卡状态，1：未开卡（发卡），2：正常（开卡 ），3：请假，4：过期 5：挂失 6：停卡
       CASE uc.operation_type
           WHEN 1 THEN '未开卡'
           WHEN 2 THEN '正常'
           WHEN 3 THEN '请假'
           WHEN 4 THEN '过期'
           WHEN 5 THEN '挂失'
           WHEN 6 THEN '停卡'
           ELSE '未知'
           END                                AS `卡状态`,
       IF(uc.is_delete = 0, '正常', '已删除') AS `是否删除`
FROM user_card AS uc
         INNER JOIN store AS s ON uc.store_uuid = s.uuid
         INNER JOIN `user` AS u ON uc.user_uuid = u.uuid
         INNER JOIN store_card AS sc ON sc.uuid = uc.store_card_uuid
WHERE uc.is_delete = 0
  AND uc.activate_type IN (2)
  AND uc.activate_time BETWEEN '2024-08-02 23:00:00' and '2024-08-16 23:00:00'
  AND uc.create_time <= '2024-08-02 23:00:00'
  AND uc.operation_type = 2
  AND uc.is_delete = 0
  AND sc.effective_unit = 1
AND  TIMESTAMPDIFF(MONTH, uc.start_time, uc.end_time) > sc.effective_number;


SELECT uc.uuid                                          AS `卡ID`,
       uc.card_no                                       AS `卡号`,
       uc.card_name                                     AS `卡名称`,
       u.`nick_name`                                    AS `持卡人`,
       s.name                                           AS `门店名称`,
       IF
       (uc.activate_type = 2, '第一次预约开发', '特定时间开卡')
                                                        AS `开卡方式`,
       uc.create_time                                   AS `创建时间`,
       #uc.effective_unit 有效期数值单位，1：月，2：天
       CASE uc.effective_unit
           WHEN 1 THEN '月'
           WHEN 2 THEN '天'
           ELSE '未知'
           END                                          AS `发卡-有效期单位`,
       uc.effective_number                              AS `发卡-有效期数值`,
       #sc.effective_unit 有效期数值单位，1：月，2：天
#        CASE sc.effective_unit
#            WHEN 1 THEN '月'
#            WHEN 2 THEN '天'
#            ELSE '未知'
#            END                                AS `会员卡名称-有效期单位`,
#        sc.effective_number                    AS `会员卡名称-有效期数值`,
       DATEDIFF(uc.end_time, uc.start_time)             AS `有效天数`,
       TIMESTAMPDIFF(MONTH, uc.start_time, uc.end_time) AS `有效月数`,
       uc.update_time                                   AS `更新时间`,
       uc.activate_time                                 AS `开卡时间`,
       uc.start_time                                    AS `开始时间`,
       uc.end_time                                      AS `结束时间`,
# uc.type 1：期限卡，2：次数卡，3：储值卡
       CASE uc.type
           WHEN 1 THEN '期限卡'
           WHEN 2 THEN '次数卡'
           WHEN 3 THEN '储值卡'
           ELSE '未知'
           END                                          AS `卡类型`,
# uc.operation_type 会员卡状态，1：未开卡（发卡），2：正常（开卡 ），3：请假，4：过期 5：挂失 6：停卡
       CASE uc.operation_type
           WHEN 1 THEN '未开卡'
           WHEN 2 THEN '正常'
           WHEN 3 THEN '请假'
           WHEN 4 THEN '过期'
           WHEN 5 THEN '挂失'
           WHEN 6 THEN '停卡'
           ELSE '未知'
           END                                          AS `卡状态`,
       IF(uc.is_delete = 0, '正常', '已删除')           AS `是否删除`
FROM user_card AS uc
         INNER JOIN store AS s ON uc.store_uuid = s.uuid
         INNER JOIN `user` AS u ON uc.user_uuid = u.uuid
         INNER JOIN store_card AS sc ON sc.uuid = uc.store_card_uuid
WHERE uc.is_delete = 0
  AND uc.activate_type IN (2)
  AND uc.activate_time BETWEEN '2024-08-01 23:00:00' and '2024-08-28 23:00:00'
  AND uc.create_time >= '2024-08-02 23:00:00'
  AND uc.operation_type = 2
  AND uc.is_delete = 0
  AND uc.effective_unit = 2
  AND uc.effective_number - DATEDIFF(uc.end_time, uc.start_time) > 1;


#### 3.0.0 发卡问题 end