### 到访人数据查询
SELECT cc.uuid opportunity_contact_uuid,
       cc.NAME opportunity_contact_name,
       o.uuid  opportunity_uuid,
       o.NAME  opportunity_name,
       cc.phone
FROM company_contacts cc
         JOIN opportunity o ON cc.opportunity_uuid = o.uuid AND o.is_delete = 0
WHERE cc.is_delete = 0
     AND cc.phone='18516698042'
ORDER BY cc.sort, cc.uuid;

##  合同单价和合同单元租金不一致的新建待修改合同信息
SELECT c.contract_code  AS `合同编号`,
       SUM(cu.rent)     AS `合同单元租金总和`,
       ccprs.unit_price AS `合同单价`
FROM contract_unit AS cu
         INNER JOIN contract AS c ON c.uuid = cu.contract_uuid AND c.is_draft = 0
         INNER JOIN contract_clause_pay_rent_setting AS ccprs ON ccprs.contract_uuid = c.uuid AND ccprs.type = 1
WHERE ccprs.is_delete = 0
  AND cu.is_delete = 0
  AND c.contract_status IN (2)
  AND c.project_uuid NOT IN (
                             '31cf853be4424e239dd4748637965ad6',
                             '3936309d0ed14bf7a324d22b0475dfcb',
                             '50bd66a25dfe4489a5d51b9a3dc030e6',
                             '50e593d2093b4a179e8a1aac2d8294f6',
                             '767f8ca2152c42fba8c425241609028a',
                             '8f906e20ce0f4d10b2b0d8c95436fe61'
    )
GROUP BY c.uuid
HAVING SUM(cu.rent) <> `合同单价`;

SELECT
    contract_code AS `合同编号`,
    bill_code AS `账单编号`,
    fee_type AS `费用类型`,
    should_amount AS `应收金额`,
    charging_start_date AS `计费开始日期`,
    charging_end_date AS `计费结束日期`,
    pay_date AS `付款日期`,
    create_time AS `创建时间`,
    bill_uuid AS `账单UUID`,
    add_bills_manually,
    is_delete
    FROM bill_item
WHERE contract_code='HT-CQS-GJZXT1-2705-07-202302-1368'
AND fee_type ='滞纳金';

# 关闭账单
UPDATE bill AS b
    INNER JOIN bill_item AS bi ON b.uuid = bi.bill_uuid
SET b.settlement_status=4,
    bi.settlement_status=4
WHERE b.bill_code IN (
                      'ZD-CDS-CDLRZDGC-2608-202306-1338799',
                      'ZD-CDS-CDLRZDGC-2608-202306-1338798'
    )
  AND b.is_delete = 0
  AND bi.is_delete = 0;

SELECT c.uuid          AS `合同ID`,
       c.contract_code AS `合同编号`,
       c.project_name AS `项目名称`,
       c.leased_area   AS `合同租赁面积`,
       l.uuid AS      `意向书ID`,
       l.contract_code AS `意向书编号`,
       l.leased_area  AS `意向书租赁面积`
FROM contract AS c
         INNER JOIN contract AS l ON c.associations_uuid = l.uuid
WHERE c.is_delete = 0
  AND c.is_draft = 0
  AND c.contract_type=1
   AND c.associations_uuid is not null
  AND l.is_delete = 0
  AND l.is_draft = 0
  AND l.contract_type=2
AND c.leased_area != l.leased_area;

SELECT C.uuid          AS `合同ID`,
       c.create_time   AS `创建时间`,
       c.contract_code AS `合同编号`,
       r.name          AS `城市名称`,
       c.project_name  AS `项目名称`,
       CASE c.contract_status
        WHEN 1 THEN '新建待审批'
        WHEN 2 THEN '新建待修改'
        WHEN 3 THEN '变更待审批'
        WHEN 4 THEN '变更待修改'
        WHEN 5 THEN '待执行'
        WHEN 6 THEN '正常执行'
        WHEN 7 THEN '退租待审批'
        WHEN 8 THEN '退租待修改'
        WHEN 9 THEN '退租待执行'
        WHEN 10 THEN '已退租'
        WHEN 11 THEN '作废待审批'
        WHEN 12 THEN '作废待修改'
        WHEN 13 THEN '已作废'
        WHEN 14 THEN '到期未处理'
        WHEN 15 THEN '续租待审批'
        WHEN 16 THEN '续租待修改'
        WHEN 17 THEN '变更中'
        WHEN 18 THEN '变更待执行'
        WHEN 19 THEN '续租待执行'
        WHEN 20 THEN '续租正常执行'
        ELSE '未知状态'
    END AS `合同状态`
FROM contract AS C
         INNER JOIN project AS p ON p.uuid = c.project_uuid
         INNER JOIN region AS r ON r.uuid = p.region_uuid
         INNER JOIN (SELECT ccf.contract_uuid,
                            COUNT(ccf.contract_uuid) AS `count`
                     FROM contract_custom_fields ccf
                     WHERE ccf.field_name IN ('仲裁名称', '合同模版违约金说明')
                     GROUP BY ccf.contract_uuid
                     HAVING `count` < 2
                     ORDER BY `count` desc) AS static ON static.contract_uuid = c.uuid
WHERE c.is_delete = 0
  AND c.is_draft = 0
AND r.uuid !='cfa7cfe133bb42d484e3260066903268'
AND c.contract_status NOT IN(11,12,13,9,10)
ORDER BY c.create_time DESC ;

SELECT C.uuid          AS `合同ID`,
       c.create_time   AS `创建时间`,
       c.contract_code AS `合同编号`,
       r.name          AS `城市名称`,
       c.project_name  AS `项目名称`,
       CASE c.contract_status
        WHEN 1 THEN '新建待审批'
        WHEN 2 THEN '新建待修改'
        WHEN 3 THEN '变更待审批'
        WHEN 4 THEN '变更待修改'
        WHEN 5 THEN '待执行'
        WHEN 6 THEN '正常执行'
        WHEN 7 THEN '退租待审批'
        WHEN 8 THEN '退租待修改'
        WHEN 9 THEN '退租待执行'
        WHEN 10 THEN '已退租'
        WHEN 11 THEN '作废待审批'
        WHEN 12 THEN '作废待修改'
        WHEN 13 THEN '已作废'
        WHEN 14 THEN '到期未处理'
        WHEN 15 THEN '续租待审批'
        WHEN 16 THEN '续租待修改'
        WHEN 17 THEN '变更中'
        WHEN 18 THEN '变更待执行'
        WHEN 19 THEN '续租待执行'
        WHEN 20 THEN '续租正常执行'
        ELSE '未知状态'
    END AS `合同状态`
FROM contract AS C
         INNER JOIN project AS p ON p.uuid = c.project_uuid
         INNER JOIN region AS r ON r.uuid = p.region_uuid
         LEFT JOIN (SELECT ccf.contract_uuid,
                            COUNT(ccf.contract_uuid) AS `count`
                     FROM contract_custom_fields ccf
                     WHERE ccf.field_name IN ('仲裁名称', '合同模版违约金说明')
                     GROUP BY ccf.contract_uuid
                     ORDER BY `count` desc) AS static ON static.contract_uuid = c.uuid
WHERE c.is_delete = 0
  AND c.is_draft = 0
AND r.uuid !='cfa7cfe133bb42d484e3260066903268'
AND c.contract_status NOT IN(11,12,13,9,10)
AND static.contract_uuid is null
ORDER BY c.create_time DESC ;