-- 机构设备数量
SELECT COUNT(*)
FROM t_device AS d
WHERE d.org_id = 1843925053672611842
  AND d.is_delete = 0;

-- 机构全部设备版本分布
SELECT o.org_name                           AS `机构名称`,
       d.current_device_application_version AS `设备版本`,
       COUNT(d.device_id)                   AS `设备数量`
FROM t_device AS d
         INNER JOIN t_org AS o ON d.org_id = o.org_id
WHERE d.org_id = 1843925053672611842
  AND d.is_delete = 0
GROUP BY d.current_device_application_version
ORDER BY `设备数量` DESC;

-- 机构已激活设备版本分布
SELECT o.org_name                           AS `机构名称`,
       d.current_device_application_version AS `设备版本`,
       COUNT(d.device_id)                   AS `设备数量`
FROM t_device AS d
         INNER JOIN t_org AS o ON d.org_id = o.org_id
         LEFT JOIN t_user_device_codes AS udc ON udc.device_id = d.device_id AND udc.is_delete = 0
WHERE d.org_id = 1843925053672611842
  AND d.is_delete = 0
  AND udc.user_device_code_id IS NOT NULL
GROUP BY d.current_device_application_version
ORDER BY `设备数量` DESC;

SELECT SUM(`设备数量`)
FROM (SELECT o.org_name                           AS `机构名称`,
             d.current_device_application_version AS `设备版本`,
             COUNT(d.device_id)                   AS `设备数量`
      FROM t_device AS d
               INNER JOIN t_org AS o ON d.org_id = o.org_id
               INNER JOIN t_user_device_codes AS udc ON udc.device_id = d.device_id AND udc.is_delete = 0
      WHERE d.org_id = 1843925053672611842
        AND d.is_delete = 0
      GROUP BY d.current_device_application_version
      ORDER BY `设备数量` DESC) AS t;

-- 机构未激活设备版本分布
SELECT o.org_name                           AS `机构名称`,
       d.current_device_application_version AS `设备版本`,
       COUNT(d.device_id)                   AS `设备数量`
FROM t_device AS d
         INNER JOIN t_org AS o ON d.org_id = o.org_id
         LEFT JOIN t_user_device_codes AS udc ON udc.device_id = d.device_id AND udc.is_delete = 0
WHERE d.org_id = 1843925053672611842
  AND d.is_delete = 0
  AND udc.user_device_code_id IS NULL
GROUP BY d.current_device_application_version
ORDER BY `设备数量` DESC;

SELECT SUM(`设备数量`)
FROM (SELECT o.org_name                           AS `机构名称`,
             d.current_device_application_version AS `设备版本`,
             COUNT(d.device_id)                   AS `设备数量`
      FROM t_device AS d
               INNER JOIN t_org AS o ON d.org_id = o.org_id
               LEFT JOIN t_user_device_codes AS udc ON udc.device_id = d.device_id AND udc.is_delete = 0
      WHERE d.org_id = 1843925053672611842
        AND d.is_delete = 0
        AND udc.user_device_code_id IS NULL
      GROUP BY d.current_device_application_version
      ORDER BY `设备数量` DESC) AS t;

# 机构在线用户信息
SELECT u.user_name AS `用户姓名`,
       u.nick_name AS `用户昵称`,
       u.email     AS `用户邮箱`,
#     用户状态，0:禁用，1:启用
       case u.user_status
           when 0 then '禁用'
           when 1 then '启用'
           else '未知状态'
           end     AS `用户状态(禁用/启用)`,
# 用户类型，0:普通用户，1:会员用户
       case u.user_type
           when 0 then '普通用户'
           when 1 then '会员用户'
           else '未知类型'
           end     AS `用户类型(普通用户/会员用户)`
FROM t_user AS u
         INNER JOIN t_user_device_codes AS udc ON udc.user_id = u.user_id
    AND udc.is_delete = 0
         INNER JOIN t_device AS d ON d.device_id = udc.device_id
WHERE d.org_id = 1843925053672611842
  AND d.is_delete = 0
  AND u.is_delete = 0
GROUP BY u.user_id;

