# bill 新增字段
ALTER TABLE bill
ADD COLUMN pay_type INT NULL COMMENT '缴费方式 1:线下缴费 2:线上微信缴费',

ADD COLUMN bill_settlement_status TINYINT(1) NULL COMMENT '账单结清状态  0:待审核 1:待收款 2:部分结清 3:已结清 4:逾期未结清 5:已关闭',

ADD COLUMN pending_audit_amount DECIMAL(10,2) NULL COMMENT '待审金额';

# bill_item 新增字段
ALTER TABLE bill_item
ADD COLUMN pay_type INT NULL COMMENT '缴费方式 1:线下缴费 2:线上微信缴费',

ADD COLUMN bill_settlement_status TINYINT(1) NULL COMMENT '账单结清状态  0:待审核 1:待收款 2:部分结清 3:已结清 4:逾期未结清 5:已关闭',

ADD COLUMN pending_audit_amount DECIMAL(10,2) NULL COMMENT '待审金额';

## 账单审核记录表
CREATE TABLE `bill_audit_record`
(
    `bill_audit_record_uuid` bigint(20)                               NOT NULL COMMENT 'BillAuditRecord uuid',
    `bill_uuid`              bigint(20)                               NOT NULL COMMENT 'bill uuid',
    `bill_code`              varchar(255)                             NULL COMMENT 'bill code',
    `contract_code`          varchar(255)                             NULL COMMENT 'contract code',
    `audit_status`           tinyint(1)                               NOT NULL COMMENT '审核状态 0: 待审核 1: 审核通过 2: 审核不通过',
    `audit_amount`           decimal(12, 2) DEFAULT 0.00 COMMENT '审核金额',
    `audit_time`             datetime                                 NOT NULL COMMENT '审核时间',
    `create_uuid`            varchar(100)                             NOT NULL COMMENT '创建人',
    `create_name`            varchar(100)   DEFAULT NULL COMMENT '创建人姓名',
    `create_time`            datetime       DEFAULT CURRENT_TIMESTAMP null comment '创建时间',
    `update_time`            datetime       DEFAULT CURRENT_TIMESTAMP null on update CURRENT_TIMESTAMP comment '修改时间',
    `remark`                 text           DEFAULT NULL COMMENT '备注',
    `is_delete`              tinyint(1)     DEFAULT '0' COMMENT '是否删除 0: 未删除 1: 已删除',
    PRIMARY KEY (`bill_audit_record_uuid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='账单审核记录表';

# 账单回执
# is_delete 是否删除 0: 未删除 1: 已删除
ALTER TABLE bill_reply_slip
ADD COLUMN is_delete TINYINT(1)  DEFAULT 0 COMMENT '是否删除 0: 未删除 1: 已删除' ;

ALTER TABLE bill
ADD COLUMN  project_contract_info_uuid VARCHAR(64) COMMENT 'projectContractInfoUuid';

ALTER TABLE bill_item
ADD COLUMN  project_contract_info_uuid VARCHAR(64) COMMENT 'projectContractInfoUuid';

alter table bill
    modify contract_uuid varchar(64) not null comment 'contract uuid';


alter table bill_item
    modify contract_uuid varchar(64) not null comment 'contract uuid';

alter table lease_refund_record
    modify contract_uuid varchar(64) not null comment 'contract  uuid';

alter table contract_unit
    modify contract_uuid varchar(64) not null comment 'contract uuid';

alter table bill_reply_slip
    add bill_operation_record_uuid bigint(19) null comment 'bill_operation_record uuid';

alter table bill
    add pending_audit_amount_pay_time date null comment '当前待审金额支付时间';

alter table bill_item
    add pending_audit_amount_pay_time date null comment '当前待审金额支付时间';

alter table bill
    add bill_pay_record_uuid bigint(19) null comment '账单缴费明细 uuid (bill_pay_record)';

alter table bill_item
    add bill_pay_record_uuid bigint(19) null comment '账单缴费明细 uuid (bill_pay_record)';

create index bill_bill_pay_record_uuid_index
    on bill (bill_pay_record_uuid);

create index bill_item_bill_pay_record_uuid_index
    on bill_item (bill_pay_record_uuid);

alter table bill_audit_record
    add bill_pay_record_uuid bigint(19) null comment '账单缴费明细 uuid (bill_pay_record)';

create index bill_audit_record_bill_pay_record_uuid_index
    on bill_audit_record (bill_pay_record_uuid);












