# 通知文书(入驻通知:交楼单,温馨涵)
DROP TABLE IF EXISTS notification_instruments;
-- auto-generated definition
create table notification_instruments
(
    uuid                         bigint                             not null comment '主键 uuid'
        primary key,
    document_name                varchar(100)                       null comment '文档名称',
    instruments_type             int(1)                             not null comment '文书/文档类型 1:交楼单 2:温馨涵',
    content_type                 int(1)   default 1                 null comment '文本类型 1:world 2:富文本',
    content_detail               text                               null comment '内容详情(富文本内容 content_type=2)',
    contract_model_uuid          bigint                             null comment 'contract_model uuid(模版uuid)',
    dispatches_num               int(3)   default 0                 null comment '下发次数  default:0',
    add_new_cities_automatically int(1)   default 0                 null comment '是否自动添加新增城市和楼宇到当前文档 0:不自动添加 1:自动添加 default:0',
    is_delete                    int(1)   default 0                 null comment '是否删除:  0:未删 1:已删除  default:0',
    create_time                  datetime default CURRENT_TIMESTAMP null comment '创建时间',
    create_uuid                  char(32)                           null comment '创建人',
    creator_name                 varchar(64)                        null comment '创建人姓名',
    update_uuid                  char(32)                           null comment '修改人',
    updater_name                 varchar(64)                        null comment '更新人姓名',
    update_time                  datetime default CURRENT_TIMESTAMP null on update CURRENT_TIMESTAMP comment '修改时间'
)
    comment '通知文书(入驻通知:交楼单,温馨涵)';

create index notification_instruments_add_new_cities_automatically_index
    on notification_instruments (add_new_cities_automatically);




# 通知文书(入驻通知:交楼单,温馨涵) 项目信息
DROP TABLE IF EXISTS notification_instruments_project;
-- auto-generated definition
create table notification_instruments_project
(
    uuid                          bigint                             not null comment '主键 uuid'
        primary key,
    notification_instruments_uuid bigint                             not null comment 'notification_instruments uuid',
    project_uuid                  varchar(32)                        not null comment 'project uuid',
    picture_uuid                  char(32)                           null comment 'picture uuid',
    img_url                       varchar(255)                       null comment '项目图片地址 可能会没有值呢',
    name                          varchar(32)                        null comment '项目名',
    region_uuid                   varchar(32)                        null comment '区域uuid',
    region_name                   varchar(128)                       null comment '区域名、即城市名称 region name',
    is_delete                     int(1)   default 0                 null comment '是否删除:  0:未删 1:已删除  default:0',
    create_time                   datetime default CURRENT_TIMESTAMP null comment '创建时间',
    create_uuid                   char(32)                           null comment '创建人',
    creator_name                  varchar(64)                        null comment '创建人姓名',
    update_uuid                   char(32)                           null comment '修改人',
    updater_name                  varchar(64)                        null comment '更新人姓名',
    update_time                   datetime default CURRENT_TIMESTAMP null on update CURRENT_TIMESTAMP comment '修改时间'
)
    comment '通知文书(入驻通知:交楼单,温馨涵) 项目信息';

create index notification_instruments_project_project_uuid_index
    on notification_instruments_project (project_uuid);

create index notification_instruments_project_region_uuid_index
    on notification_instruments_project (region_uuid);

create index notification_instruments_uuid_index
    on notification_instruments_project (notification_instruments_uuid);



#  通知文书(入驻通知:交楼单,温馨涵) 统计
DROP TABLE IF EXISTS notification_instruments_record;
-- auto-generated definition
create table notification_instruments_record
(
    uuid                                             bigint                             not null comment '主键 uuid'
        primary key,
    notification_instruments_uuid                    bigint                             not null comment 'notification_instruments uuid',
    notification_instruments_sending_statistics_uuid bigint                             not null comment 'notification_instruments_sending_statistics uuid',
    document_name                                    varchar(100)                       null comment '文档名称',
    company_name                                     varchar(32)                        null comment '承租方名称 (冗余于company 表)',
    company_uuid                                     char(32)                           null comment 'company uudid',
    project_uuid                                     varchar(32)                        not null comment 'project uuid',
    name                                             varchar(32)                        null comment '项目名',
    region_uuid                                      varchar(32)                        null comment '区域uuid',
    region_name                                      varchar(128)                       null comment '区域名、即城市名称 region name',
    notes_on_use                                     text                               null comment '使用须知',
    signing_time_for_party_a                         date                               null comment '甲方(承租方)签约时间',
    signing_time_for_party_b                         date                               null comment '乙方(出租方)签约时间',
    authorized_delivery_person                       varchar(50)                        null comment '授权交楼人',
    contact_phone_number                             varchar(30)                        null comment '联系电话',
    level_name                                       varchar(50)                        null comment '楼层',
    obj_no                                           varchar(255)                       null comment '单元号  套间号 ， 工位',
    uses                                             varchar(100)                       null comment '用途 最大限制 100 字',
    fid                                              varchar(50)                        null comment 'fid (蓝凌OA 审批实例 id)',
    audit_status                                     int(1)                             null comment '审核状态 0:待审核 1:已通过 2:已拒绝 ',
    signing_status                                   int(1)                             null comment '签约状态 0:未查看 1:未签署 2:签署中 3:已签署 4:已拒绝',
    signatories_uuid                                 char(32)                           null comment '签署人 uuid',
    signatories_name                                 varchar(64)                        null comment '签署人 name',
    signing_time                                     datetime                           null comment '签署时间',
    initiation_time                                  datetime                           null comment '发起时间',
    remark                                           varchar(500)                       null comment '备注 最大限制 500 字',
    contract_file_uuid                               bigint(19)                         null comment 'contract_file uuid',
    is_delete                                        int(1)   default 0                 null comment '是否删除:  0:未删 1:已删除  default:0',
    is_watched                                       int(1)   default 0                 null comment '是否查看 0:未查看 1:已查看  default:0',
    create_time                                      datetime default CURRENT_TIMESTAMP null comment '创建时间',
    create_uuid                                      char(32)                           null comment '创建人',
    creator_name                                     varchar(64)                        null comment '创建人姓名',
    update_uuid                                      char(32)                           null comment '修改人',
    updater_name                                     varchar(64)                        null comment '更新人姓名',
    update_time                                      datetime default CURRENT_TIMESTAMP null on update CURRENT_TIMESTAMP comment '修改时间',
    flow_id                                          varchar(50)                        null comment 'e 签宝 流程id',
    is_finished                                      int(1)   default 0                 null comment '是否完成蓝凌 OA 审批  0:未完成  1:已完成  default: 0',
    trance_id                                        varchar(50)                        null comment '跟踪 id 确保同样的数据不会重复操作',
    file_url                                         varchar(200)                       null comment '文件地址',
    level_uuid                                       varchar(32)                        null comment '所属楼层Id，refer building表',
    content_detail                                   text                               null comment '内容详情(富文本内容 content_type=2)'
)
    comment '通知文书(入驻通知:交楼单,温馨涵) 记录';

create index notification_instruments_record_company_uuid_index
    on notification_instruments_record (company_uuid);

create index notification_instruments_record_flow_id_index
    on notification_instruments_record (flow_id);

create index notification_instruments_record_is_finished_index
    on notification_instruments_record (is_finished);

create index notification_instruments_record_trance_id_index
    on notification_instruments_record (trance_id);

create index notification_instruments_sending_statistics_uuid_index
    on notification_instruments_record (notification_instruments_sending_statistics_uuid);

create index notification_instruments_uuid_index
    on notification_instruments_record (notification_instruments_uuid);


DROP TABLE  IF EXISTS notification_instruments_sending_statistics;
-- auto-generated definition
create table notification_instruments_sending_statistics
(
    uuid                     bigint                               not null comment '主键 uuid'
        primary key,
    company_name             varchar(32)                          null comment '承租方名称 (冗余于company 表)',
    company_uuid             char(32)                             null comment 'company uudid',
    company_type             tinyint(1) default 1                 null comment '企业类型，1企业，2个人',
    concat                   varchar(32)                          null comment '联系人',
    phone                    varchar(32)                          null comment '联系人联系方式',
    project_unit_rental_uuid varchar(32)                          not null comment 'project_unit_rental  uuid',
    project_uuid             varchar(32)                          not null comment 'project uuid',
    name                     varchar(32)                          null comment '项目名',
    region_uuid              varchar(32)                          null comment '区域uuid',
    region_name              varchar(128)                         null comment '区域名、即城市名称 region name',
    lease_start_date         date                                 null comment '租赁起始日期',
    lease_end_date           date                                 null comment '租赁结束日期',
    dispatches_num           int(3)     default 0                 null comment '企业下发文档总数  default:0',
    sign_document_num        int(3)     default 0                 null comment '企业签署文档总数(温馨涵)  default:0',
    signing_document_num     int(3)     default 0                 null comment '企业签约文档总数(签约涵)  default:0',
    unsigned_document_num    int(3)     default 0                 null comment '企业未签约文档总数(签约涵)/未查看文档总数(温馨涵)  default:0',
    last_issued              datetime                             null comment '最近下发时间',
    create_time              datetime   default CURRENT_TIMESTAMP null comment '创建时间',
    update_time              datetime   default CURRENT_TIMESTAMP null on update CURRENT_TIMESTAMP comment '修改时间',
    level_uuid               varchar(32)                          null comment '所属楼层Id，refer building表',
    level_name               varchar(32)                          null comment '所属楼层名，冗余buinding表'
);




















