-- 用户设备IM
CREATE TABLE `t_user_device_im` (
  `id` bigint NOT NULL,
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `device_id` bigint NOT NULL COMMENT '设备ID',
  `im_id` varchar(100) NOT NULL COMMENT 'IM用户ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户设备IM';

CREATE INDEX idx_user_id_device_id ON t_user_device_im(user_id, device_id);

CREATE INDEX idx_device_id ON t_user_device_im(device_id);

CREATE INDEX idx_im_id ON t_user_device_im(im_id);

CREATE INDEX idx_created_at ON t_user_device_im(created_at);


alter table t_user_device_im
    add im_user_id bigint null;

alter table t_user_device_im
    add constraint t_user_device_im_pk
        unique (im_user_id);



create table t_im_push_app
(
    id               bigint                             not null comment 'ID'
        primary key,
    device_id        bigint                             not null comment '设备ID',
    message_type     tinyint                            not null comment '消息类型: 0-清单 1-分类 2-事项 3-杂物 ;4-增加照片 5-删除照片;6-晚餐计划 7:用户关联设备成功 8:用户解绑设备成功',
    business_id_list text                               null comment '业务ID列表',
    push_time        datetime                           null comment '推送时间',
    status           tinyint  default 0                 not null comment '状态: 0-未推送 1-已推送',
    create_time      datetime default CURRENT_TIMESTAMP not null comment '创建时间',
    update_time      datetime default CURRENT_TIMESTAMP not null on update CURRENT_TIMESTAMP comment '更新时间'
)
    comment 'APP IM 推送表' collate = utf8mb4_general_ci;

create index idx_device_id
    on t_im_push (message_type);

create index idx_device_id_message_type
    on t_im_push (device_id, message_type);

create index idx_push_time
    on t_im_push (push_time);

create index idx_update_time
    on t_im_push (update_time);

