alter table t_ip2location_info
    change user_id business_id bigint not null comment '业务ID 用户ID/设备ID';

drop index idx_user_id on t_ip2location_info;

create index idx_business_id
    on t_ip2location_info (business_id);


alter table t_device
    add device_address_update_time datetime null comment '设备地址(country/province/city)上次更新时间' after city;


-- 创建复合索引用于地理位置三级筛选
ALTER TABLE t_device
ADD INDEX idx_device_location(country, province, city);
-- 单独按省份查询的需求
ALTER TABLE t_device ADD INDEX idx_province(province);
-- 单独按城市查询的需求
ALTER TABLE t_device ADD INDEX idx_city(city);