alter table t_device_group
    add public_cert bigint null comment '公共证书，作为 DynamoDB 表的分区键。';

alter table t_questionnaire
    modify questionnaire_name varchar(200) not null comment '问卷名称';

create index t_events_is_from_parse_ics_index
    on t_events (is_from_parse_ics);

alter table t_user_device_codes
    add hide_overdue tinyint(1) default 0 null comment '是否隐藏逾期杂物 0:否 1:是 default: 0';

alter table t_user_calendar_categories
    add is_webcal_default tinyint(1) default 0 null comment '是否是Webcal日历的默认分类 0:否 1:是 default:0';

alter table t_email_callback_log
    add sender_email VARCHAR(200) null comment '发件人邮箱';

alter table t_user
    modify user_type tinyint(1) default 0 null comment '用户类型，0:普通用户，1:会员用户 2:游客(未注册状态,仅数据库可查)';

alter table t_email_callback_log
    add utc_offset tinyint default 0 null comment '时区偏移量';

alter table t_email_callback_log
    add s3_keys text null comment 's3 key 集合';

alter table t_email_callback_log
    add magic_import_status tinyint(1) null comment '魔法导入审核状态 0:未审核 1:审核通过 2:审核不通过';


CREATE TABLE `t_magic_import_record`
(
    `magic_import_record_id` bigint(20)   NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    `batch_no`               bigint(20)   NOT NULL COMMENT '导入批次号',
    `file_name`              varchar(200)  COMMENT '导入文件名',
    `error_message`          text COMMENT '错误信息',
    `is_parsed`              tinyint(1)   NOT NULL DEFAULT '0' COMMENT '是否解析出事项 0:否 1:是',
    `parse_result`           text COMMENT '解析结果',
    `content_type`           tinyint(1)   NOT NULL COMMENT '内容类型:0:文本 1:文本附件 2:Excel 3:PDF 4:图片 5:word',
    `content`                text COMMENT '(content_type=0)内容',
    `create_time`            datetime     NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time`            datetime     NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    `is_delete`              tinyint(1)            default 0 not null comment '是否删除：0 表示否，1 表示是',
    `device_id`              bigint       not null comment '设备 ID',
    `sender_email`           varchar(240) COMMENT '发送邮箱',
    PRIMARY KEY (`magic_import_record_id`),
    KEY `idx_batch_no` (`batch_no`),
    KEY `idx_device_id` (`device_id`),
    KEY `idx_sender_email` (`sender_email`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='魔法导入记录表';

alter table t_magic_import_record
    add convert_result text null comment '转化结果';

alter table t_magic_import_record
    modify convert_result text null comment '转化结果' after parse_result;

alter table t_magic_import_record
    modify batch_no bigint not null comment '导入批次号 (t_email_callback_log#callback_id)';

alter table t_events
    add magic_import_batch_no BIGINT null comment '魔法导入批次号  (t_email_callback_log#callback_id)';

create index idx_magic_import_batch_no
    on t_events (magic_import_batch_no);

alter table t_user_calendar_categories
    add is_magic_import_default tinyint(1) default 0 null comment '是否是魔法导入的默认分类 0:否 1:是 default:0';

alter table t_events
    add magic_import_s3_key varchar(200) null comment '魔法导入文件S3key(如果是文件导入的话)';


alter table sys_oper_log
    add execution_time LONG null comment '方法执行时间（毫秒）';






CREATE TABLE `t_send_email` (
  `send_email_id` BIGINT NOT NULL COMMENT '主键ID',
  `record_id` VARCHAR(120) NOT NULL COMMENT '记录ID',
  `email` VARCHAR(200) NOT NULL COMMENT '目标邮箱地址',
  `subject` text NOT NULL COMMENT '邮件主题',
  `body` TEXT NOT NULL COMMENT '邮件内容',
  `language_type` tinyint(1) COMMENT '语言类型，0:中文(简体中文) 1:English(英语) 2:Español(西班牙语) 3:Deutsch(德语) 4:Français(法语) 5:Italiano(意大利语) 6:日本語(日语) 7:Русский(俄语)',
  `is_delete` TINYINT(1) NOT NULL DEFAULT 0 COMMENT '是否删除：0 表示否，1 表示是',
  `create_time` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`send_email_id`),
  INDEX `idx_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='发送邮件表';

alter table t_send_email
    add is_success tinyint(1) default 1 null comment '是否成功 0:失败 1:成功 default 1';

alter table t_send_email
    add error_message text null comment '错误信息';


alter table t_user
    add avatar text null comment '用户头像';

alter table t_events
    modify current_city text null comment '当前城市';

alter table t_events
    add event_record_id BIGINT null comment '事项记录ID,用于记录事项的来源(etc.webcal邮件导入的邮件记录ID)';






UPDATE t_events
SET is_from_parse_ics=1
WHERE sync_event_id is not null;

alter table t_device_group
    modify public_cert text null comment '公共证书，作为 DynamoDB 表的分区键。';

alter table t_device_group
    add order_id bigint null comment '订单ID。 作为 DynamoDB#order_id';

create index t_device_group_order_id_index
    on t_device_group (order_id);

alter table t_device_group
    change order_id dynamo_db_order_id bigint null comment '订单ID。 作为 DynamoDB#order_id';

drop index t_device_group_order_id_index on t_device_group;

create index t_device_group_dynamo_db_order_id_index
    on t_device_group (dynamo_db_order_id);

alter table t_device_group
    modify dynamo_db_order_id bigint null comment 'DynamoDB#order_id';






