alter table t_device_group
    add device_group_type tinyint default 0 null comment '设备组分类 0:相框 1:AI闹钟 default:0(相框)' after device_group_id;

alter table t_device_group
    add activation_type tinyint default 0 null comment '激活方式 0:公钥激活 1:序列号激活 default:0(公钥激活)' after device_group_type;

-- 设备表 t_device 新增字段:
-- 设备序列号
-- 设备类型 0:相框 1:AI闹钟 default 0
ALTER TABLE
    `t_device`
ADD
    COLUMN `system_device_serial_number` varchar(200) NULL COMMENT '设备序列号(系统唯一,序列号激活设备流程) t_device_serial_number.device_serial_number',
ADD
    COLUMN `device_type` TINYINT NOT NULL DEFAULT 0 COMMENT '设备类型 0:相框 1:AI闹钟 default 0';

-- 设备表序列号索引
CREATE INDEX `idx_system_device_serial_number` ON `t_device` (`system_device_serial_number`);

-- 设备码表 t_user_device_codes 新增字段:
-- 设备类型 0:相框 1:AI闹钟 default 0
ALTER TABLE
    `t_user_device_codes`
ADD
    COLUMN `device_type` TINYINT NOT NULL DEFAULT 0 COMMENT '设备类型 0:相框 1:AI闹钟 default 0';

-- 设备序列号表
CREATE TABLE `t_device_serial_number` (
    `id` BIGINT NOT NULL COMMENT '主键ID',
    -- 设备组ID
    `device_group_id` BIGINT NOT NULL COMMENT '设备组ID',
    -- 设备序列号
    `system_device_serial_number` varchar(200) NOT NULL COMMENT '设备序列号',
    -- 绑定设备MAC地址
    `device_mac_address` varchar(200) NULL COMMENT '绑定设备MAC地址',
    -- 序号
    `serial_number` INT NOT NULL COMMENT '序号(同一个设备组内的序号)',
    -- 设备类型 0:相框 1:AI闹钟
    `device_type` TINYINT NOT NULL COMMENT '设备类型 0:相框 1:AI闹钟',
    -- 序列号状态 0:未激活 1:已激活 default 0
    `status` TINYINT NOT NULL DEFAULT 0 COMMENT '序列号状态 0:未激活 1:已激活 default 0',
    -- 是否删除 0:未删除 1:已删除 default 0
    `is_deleted` TINYINT NOT NULL DEFAULT 0 COMMENT '是否删除 0:未删除 1:已删除 default 0',
    -- 创建时间 default CURRENT_TIMESTAMP
    `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    -- 更新时间 default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COMMENT = '设备序列号表';

-- 设备序列号表索引
CREATE INDEX `idx_device_group_id` ON `t_device_serial_number` (`device_group_id`);

-- 设备序列号表唯一索引
CREATE UNIQUE INDEX `idx_system_device_serial_number` ON `t_device_serial_number` (`system_device_serial_number`);



-- 用户ID 设置为非必填(AI闹钟扫描分享无法确定用户)
alter table t_user_device_share_code
    modify user_id bigint null comment '用户 ID 设置为非必填(AI闹钟扫描分享无法确定用户)';


-- 设备码长度变长
alter table t_user_device_share_code
    modify share_code varchar(220) null comment '分享码';

--  创建唯一索引
create unique index idx_share_code
    on t_user_device_share_code (share_code)
    comment '分享码';



-- 设备类型 0:相框 1:AI闹钟 default 0
alter table t_user_device_share_code
    add device_type tinyint default 0 null comment '设备类型 0:相框 1:AI闹钟 default 0' after device_id;

-- 完善字段注释说明
alter table t_user_device_share_code
    modify valid_time datetime null comment '分享码有效时间，为空则表示长期有效.(扫描分享：设备未绑定二维码长期有效)';

-- 新增设备名称字段
alter table t_user_device_codes
    add device_name varchar(200) null comment '用户创建设备输入的设备名称' after device_id;

-- 移动设备类型字段位置
alter table t_user_device_codes
    modify device_type tinyint default 0 not null comment '设备类型 0:相框 1:AI闹钟 default 0' after device_name;

-- 完善字段注释说明
alter table t_user_device_share_code
    modify device_id bigint not null comment '设备 ID (设备数据跟随的是虚拟设备) t_user_device_codes#deviceId';



alter table t_im_push
    modify message_type tinyint not null comment '消息类型: 0-清单 1-分类 2-事项 3-杂物 ;4-增加照片 5-删除照片;6-晚餐计划 7:用户关联设备成功 8:用户解绑设备成功 9:餐食分类 10:食谱 11:餐食计划 12:增加照片相册  13:编辑照片相册 14:删除照片相册 15:第三方日历订阅状态更新 16:增加贺卡 17:删除贺卡 18:贺卡自动播放 19:撤回贺卡 20: AI闹钟绑定成功';


alter table t_im_push_app
    modify message_type tinyint not null comment '消息类型: 0-清单 1-分类 2-事项 3-杂物 ;4-增加照片 5-删除照片;6-晚餐计划 7:用户关联设备成功 8:用户解绑设备成功 9:餐食分类 10:食谱 11:餐食计划 12:增加照片相册  13:编辑照片相册 14:删除照片相册 15:第三方日历订阅状态更新 16:增加贺卡 17:删除贺卡 18:贺卡自动播放 19:撤回贺卡 20: AI闹钟绑定成功';


alter table t_user_device
    add device_type tinyint default 0 null comment '设备类型 0:相框 1:AI闹钟 default 0';

alter table t_user_device_codes
    add system_device_serial_number varchar(200) null comment '设备序列号(系统唯一,序列号激活设备流程) t_device_serial_number.device_serial_number' after device_type;

alter table t_user_device_share_code
    add system_device_serial_number varchar(200) null comment '设备序列号' after valid_time;

alter table t_user_device_share_code
    modify device_id bigint null comment '设备 ID (设备数据跟随的是虚拟设备) t_user_device_codes#deviceId';

alter table t_im_push
    modify device_id bigint null comment '设备ID';

alter table t_im_push
    add system_device_serial_number varchar(200) null comment '设备序列号(系统唯一,序列号激活设备流程)' after message_type;


alter table t_im_push_app
    modify device_id bigint null comment '设备ID';

alter table t_im_push_app
    add system_device_serial_number varchar(200) null comment '设备序列号(系统唯一,序列号激活设备流程)' after message_type;

alter table t_events
    modify event_type tinyint(1) not null comment '事项类型：0 表示事项，1 表示晚餐计划，2  表示任务(原杂物) 3 餐食计划。';
