# alter table t_events
#     add rrule varchar(200) null comment 'RRule(RFC 5545),重复事项重复规则';
#
# alter table t_events
#     add ex_date text null comment 'EXDATE(RFC 5545),重复事项排除日期';
#
# create index t_event_category_relations_event_id_index
#     on t_event_category_relations (event_id);
#
# -- 创建杂物完成记录表
# CREATE TABLE t_misc_event_records
# (
#     -- 主键 ID，使用自增
#     misc_event_record_id BIGINT                             NOT NULL,
#
#     -- 设备 ID
#     device_id            BIGINT                             NOT NULL COMMENT '设备ID',
#
#     -- 事件 ID
#     origin_event_id      BIGINT                             NOT NULL COMMENT '事件ID',
#
#     start_datetime       datetime                           null comment '事项开始时间(UTC+0)',
#     start_date           date                               null comment '开始日期',
#     start_time           time                               null comment '开始时间',
#     end_datetime         datetime                           null comment '事项结束时间(UTC+0)',
#     end_date             date                               null comment '结束日期',
#     end_time             time                               null comment '结束时间',
#
#
#     completed_time       DATETIME                           NOT NULL COMMENT '杂物完成时间',
#
#     create_time          datetime default CURRENT_TIMESTAMP not null comment '创建时间，插入时自动更新',
#     update_time          datetime default CURRENT_TIMESTAMP not null on update CURRENT_TIMESTAMP comment '更新时间，插入和更新时自动更新',
#
#     -- 主键约束
#     PRIMARY KEY (misc_event_record_id),
#
#     -- 索引
#     INDEX idx_device_id (device_id),
#     INDEX idx_origin_event_id (origin_event_id),
#     INDEX idc_start_datetime (start_datetime)
# ) ENGINE = InnoDB
#   DEFAULT CHARSET = utf8mb4 COMMENT ='杂物完成记录表';
#
# create index sys_oper_log_title_index
#     on sys_oper_log (title);
#
#
# -- 创建第三方日历授权信息表
# CREATE TABLE `t_third_party_calendar_auth`
# (
#     `third_party_calendar_auth_id` BIGINT                             NOT NULL COMMENT '主键',
#     `user_id`                      BIGINT                             NOT NULL COMMENT '用户id',
#     -- 授权邮箱
#     `email`                        VARCHAR(255)                       NOT NULL COMMENT '授权邮箱',
#     -- source_type 0:google 1:outlook
#     `source_type`                  TINYINT                            NOT NULL COMMENT '第三方日历类型 0:google 1:outlook',
#     -- access_token
#     `access_token`                 TEXT                               NOT NULL COMMENT '访问令牌',
#     -- access_token_expires_in
#     `access_token_expires_in`      datetime                           NULL COMMENT '访问令牌过期时间',
#     -- refresh_token
#     `refresh_token`                TEXT                               NULL COMMENT '刷新令牌',
#     -- refresh_token_expires_in
#     `refresh_token_expires_in`     datetime                           NULL COMMENT '刷新令牌过期时间',
#     -- scope
#     `scope`                        TEXT                               NULL COMMENT '授权范围',
#     -- auth_code
#     `auth_code`                    TEXT                               NULL COMMENT '授权码',
#     -- id_token
#     `id_token`                     TEXT                               NULL COMMENT 'id_token',
#     --  is_two_way_sync     tinyint  default 0                 null comment '是否双向同步 0:否 1:是 default:0',
#     `is_two_way_sync`              TINYINT  default 0                 null comment '是否双向同步 0:否 1:是 default:0',
#     `create_time`                  datetime default CURRENT_TIMESTAMP not null comment '创建时间，插入时自动更新',
#     `update_time`                  datetime default CURRENT_TIMESTAMP not null on update CURRENT_TIMESTAMP comment '更新时间，插入和更新时自动更新',
#     PRIMARY KEY (`third_party_calendar_auth_id`)
# ) ENGINE = InnoDB
#   DEFAULT CHARSET = utf8mb4 COMMENT = '第三方日历授权信息表';
#
# CREATE INDEX `idx_user_id_email` ON `t_third_party_calendar_auth` (`user_id`, `email`);
#
# CREATE INDEX `idx_email` ON `t_third_party_calendar_auth` (`email`);
#
# -- 第三方授权日历列表
# CREATE TABLE `t_third_party_calendar_list`
# (
#     `third_party_calendar_list_id` BIGINT                             NOT NULL COMMENT '主键',
#     `third_party_calendar_auth_id` BIGINT                             NOT NULL COMMENT 't_third_party_calendar_auth 第三方日历授权id',
#     `email`                        VARCHAR(255)                       NOT NULL COMMENT '授权邮箱',
#     `calendar_id`                  VARCHAR(200)                       NOT NULL COMMENT '日历id',
#     `calendar_name`                VARCHAR(255)                       NOT NULL COMMENT '日历名称',
#     -- 是否主日历 0:否 1:是 default:0
#     `is_primary`                   TINYINT  default 0                 null comment '是否主日历 0:否 1:是 default:0',
#     -- 是否同步 0:否 1:是 default:0
#     `is_sync`                      TINYINT  default 0                 null comment '是否同步 0:否 1:是 default:0',
#     -- timeZone 时区
#     `time_zone`                    VARCHAR(150)                       NULL COMMENT '时区',
#     -- kind
#     `kind`                         VARCHAR(200)                       NULL COMMENT 'kind',
#     -- foregroundColor
#     `foreground_color`             VARCHAR(50)                        NULL COMMENT '前景色',
#     -- backgroundColor
#     `background_color`             VARCHAR(50)                        NULL COMMENT '背景色',
#     -- 原始JSON数据
#     `raw_json`                     TEXT                               NULL COMMENT '原始JSON数据',
#     `create_time`                  datetime default CURRENT_TIMESTAMP not null comment '创建时间，插入时自动更新',
#     `update_time`                  datetime default CURRENT_TIMESTAMP not null on update CURRENT_TIMESTAMP comment '更新时间，插入和更新时自动更新',
#     PRIMARY KEY (`third_party_calendar_list_id`)
# ) ENGINE = InnoDB
#   DEFAULT CHARSET = utf8mb4 COMMENT = '第三方授权日历列表';
#
# CREATE INDEX `idx_third_party_calendar_auth_id` ON `t_third_party_calendar_list` (`third_party_calendar_auth_id`);
#
# CREATE INDEX `idx_calendar_id` ON `t_third_party_calendar_list` (`calendar_id`);
#
# CREATE INDEX `idx_email` ON `t_third_party_calendar_list` (`email`);
#
#
# -- 授权日历设备关联表
# CREATE TABLE `t_third_party_calendar_device`
# (
#     `third_party_calendar_device_id` BIGINT                             NOT NULL COMMENT '主键',
#     `third_party_calendar_auth_id`   BIGINT                             NOT NULL COMMENT 't_third_party_calendar_auth 第三方日历授权id',
#     `device_id`                      BIGINT                             NOT NULL COMMENT '设备id',
#     `create_time`                    datetime default CURRENT_TIMESTAMP not null comment '创建时间，插入时自动更新',
#     `update_time`                    datetime default CURRENT_TIMESTAMP not null on update CURRENT_TIMESTAMP comment '更新时间，插入和更新时自动更新',
#     PRIMARY KEY (`third_party_calendar_device_id`)
# ) ENGINE = InnoDB
#   DEFAULT CHARSET = utf8mb4 COMMENT = '授权日历设备关联表';
#
# CREATE INDEX idx_third_party_calendar_auth_id ON t_third_party_calendar_device (third_party_calendar_auth_id);
# CREATE INDEX idx_device_id ON t_third_party_calendar_device (device_id);
#
# alter table t_third_party_calendar_list
#     add device_id BIGINT null comment '设备ID';
#
# alter table t_third_party_calendar_list
#     add record_id BIGINT null comment '记录ID(第三方日历导入的BatchId)';
#
# alter table t_events
#     modify event_record_id bigint null comment '事项记录ID,用于记录事项的来源(webcal邮件导入的邮件记录ID/第三方日历的导入的BatchId)';
#
# alter table t_events
#     add event_zone_id varchar(35) null comment '事项时区的 ZoneId(Google Calendar)';
#
# alter table t_events
#     add sync_calendar_id varchar(300) null comment '第三方日历日历ID(Google Calendar/Outlook Calendar)';
#
# alter table t_events
#     modify sync_calendar_id varchar(500) null comment '第三方日历日历ID(Google Calendar/Outlook Calendar)';
#
# alter table t_events
#     add recurring_event_id varchar(500) null comment 'Google Calendar recurringEventId';
#
# alter table t_events
#     add i_cal_uid varchar(500) null comment 'Google Calendar iCalUID RFC5545 中定义的事件唯一标识符。它用于在日历系统中唯一标识事件，并且在通过import方法导入事件时必须提供。  请注意，iCalUID 和 id 并不相同，在创建事件时应仅提供其中一个。它们在语义上的一个区别在于，在周期性事件中，一个事件的所有出现都具有不同的 id，而它们都共享相同的 iCalUID。如需使用其 iCalUID 检索事件，请使用 iCalUID 参数调用 events.list 方法。如需使用事件的 id 检索事件，请调用 events.get 方法。';
#
# create index idx_sync_calendar_id
#     on t_events (sync_calendar_id);
#
# alter table t_events
#     add sync_third_event_id varchar(500) null comment '第三方日历事项ID';
#
# create index idx_sync_third_event_id
#     on t_events (sync_third_event_id);
#
#
# alter table t_user_calendar_categories
#     modify sync_calender_id varchar(500) null comment '同步第三方的日历 ID';
#
# create index t_user_calendar_categories_sync_calender_id_index
#     on t_user_calendar_categories (sync_calender_id);
#
# create index t_events_event_record_id_index
#     on t_events (event_record_id);
#
# alter table t_events
#     add sync_event_color varchar(20) null comment '事项颜色(Google Calendar 同步的分类事日历，但是可以设置不同的事项颜色)';
#
# alter table t_events
#     add sync_calendar_name varchar(100) null comment '第三方日历名称 (Google Calendar/Outlook Calendar)';
#
#
# alter table t_events
#     add source_type tinyint null comment '第三方日历类型，0:表示Google，1:表示Outlook';
#
#
# alter table t_events
#     drop column google_calendar_id;
#
# alter table t_events
#     drop column outlook_calendar_id;
#
# alter table t_third_party_calendar_list
#     add source_type tinyint null comment '第三方日历类型，0:表示Google，1:表示Outlook';
#
#
# create index t_events_source_type_index
#     on t_events (source_type);
#
#
#
#
#
#
#
#   执行时间： 2024-11-25 10:00:00
