alter table company_cfg_reserve
    modify project_uuid char(32) not null comment '项目uuid ';

alter table company_cfg_reserve
    add project_name varchar(32) null comment '项目名称' after project_uuid;

alter table company_cfg_reserve
    change num cycle tinyint(1) default 15 null comment '企业可预定周期(天) 7:7天 15:15天  30:30天  默认15天';

alter table company_cfg_reserve
    modify duration decimal(6, 2) default 4.00 null comment '每天预定时长';

alter table company_cfg_reserve
    modify is_limit tinyint(1) default 0 null comment '是否超出限制提交, 1:是 0,否';

alter table company_cfg_reserve
    modify duration decimal(6, 2) default 4.00 null comment '企业每月免费时长(h)';

#  room 添加字段 office_building_uuid          char(32)                             null comment '楼栋uuid（office_building表）'
alter table room
    add office_building_uuid char(32) null comment '楼栋uuid（office_building表）' after company_uuid;
# room 添加字段 office_building_name          varchar(32)                          null comment '楼栋名称'
alter table room
    add office_building_name varchar(32) null comment '楼栋名称' after office_building_uuid;

create index company_cfg_reserve_project_uuid_index
    on company_cfg_reserve (project_uuid);

alter table room_order
    add contact_name varchar(15) null comment '联系人名称' after theme;

alter table room_order
    add constraint room_order_pk
        primary key (uuid);
create index room_order_room_uuid_index
    on room_order (room_uuid);
# index status
create index room_order_status_index
    on room_order (status);
# index: begin_time
create index room_order_begin_time_index
    on room_order (begin_time);
# index end_time
create index room_order_end_time_index
    on room_order (end_time);
create index room_order_company_name_index
    on room_order (company_name);
alter table room_order
    add appointment_type tinyint(1) default 0 null comment '预约类型 0:用户预约 1:后台预约';

alter table room_order
    modify appointment_type tinyint(1) default 0 null comment '预约类型枚举 0:用户预约 1:后台预约 2:后台预约,未查询到公司信息';

create index idx_project_uuid
    on room_template (project_uuid);

alter table room_template
    add constraint room_template_pk
        primary key (uuid);

create index idx_project_uuid_region_uuid
    on room_template (project_uuid, region_uuid);

alter table room_price
    add constraint room_price_pk
        primary key (uuid);
create index room_price_template_uuid_index
    on room_price (template_uuid);

alter table room_rule_config
    add constraint room_rule_config_pk
        primary key (uuid);

create index room_rule_config_region_uuid_index
    on room_rule_config (region_uuid);

alter table room_pay
    add constraint room_pay_pk
        primary key (uuid);

alter table room
    add constraint room_pk
        primary key (uuid);

create index room_region_uuid_index
    on room (region_uuid);

create index room_project_uuid_region_uuid_index
    on room (project_uuid, region_uuid);

alter table room_type
    add constraint room_type_pk
        primary key (uuid);

alter table company_cfg_reserve
    modify cycle tinyint(1) default 15 null comment '企业可预定周期(天)  3:3天 7:7天 15:15天  30:30天';










