import Main from "@/components/main";

/**
 * iview-admin中meta除了原生参数外可配置的参数:
 * meta: {
 *  title: { String|Number|Function }
 *         显示在侧边栏、面包屑和标签栏的文字
 *         使用'{{ 多语言字段 }}'形式结合多语言使用，例子看多语言的路由配置;
 *         可以传入一个回调函数，参数是当前路由对象，例子看动态路由和带参路由
 *  hideInBread: (false) 设为true后此级路由将不会出现在面包屑中，示例看QQ群路由配置
 *  hideInMenu: (false) 设为true后在左侧菜单不会显示该页面选项
 *  notCache: (false) 设为true后页面在切换标签后不会缓存，如果需要缓存，无需设置这个字段，而且需要设置页面组件name属性和路由配置的name一致
 *  access: (null) 可访问该页面的权限数组，当前路由设置的权限会影响子路由
 *  icon: (-) 该页面在左侧菜单、面包屑和标签导航处显示的图标，如果是自定义图标，需要在图标名称前加下划线'_'
 *  beforeCloseName: (-) 设置该字段，则在关闭当前tab页时会去'@/router/before-close.js'里寻找该字段名对应的方法，作为关闭前的钩子函数
 * }
 */

export default [
  {
    path: "/login",
    name: "login",
    meta: {
      title: "Login - 登录",
      hideInMenu: true
    },
    component: () => import("@/view/login/login.vue")
  },
  {
    path: "/",
    name: "_home",
    redirect: "/home",
    component: Main,
    meta: {
      title: "签到活动管理",
      hideInMenu: false,
      icon: "md-home",
      notCache: true,
      showbr: false
    },
    children: [
      {
        path: "/home",
        name: "home",
        meta: {
          hideInMenu: false,
          title: "用户列表",
          notCache: true,
          showbr: true
        },
        component: () => import("@/view/signIn/userList.vue")
      },
      {
        path: "/signIn/signInList",
        name: "signInList",
        meta: {
          hideInMenu: false,
          title: "签到活动",
          notCache: true,
          showbr: true
        },
        component: () => import("@/view/signIn/signInList.vue")
      },
      {
        path: "/signIn/setTabs",
        name: "signSetTabs",
        meta: {
          hideInMenu: false,
          title: "签到奖励设置",
          notCache: true,
          showbr: true
        },
        component: () => import("@/view/signIn/setTabs.vue")
      },
      {
        path: "/signIn/photoReview",
        name: "photoReview",
        meta: {
          hideInMenu: false,
          title: "签到照片审核",
          notCache: true,
          showbr: true
        },
        component: () => import("@/view/signIn/photoReview.vue")
      },
      {
        path: "/signIn/dataStatistics",
        name: "dataStatistics",
        meta: {
          hideInMenu: false,
          title: "数据统计",
          notCache: true,
          showbr: true
        },
        component: () => import("@/view/signIn/dataStatistics.vue")
      },
      {
        path: "/signIn/userAcDetail",
        meta: {
          title: "详情",
          hideInMenu: true,
          showbr: true
        },
        component: () => import("@/view/signIn/userAcDetail.vue")
      },
      {
        path: "/signIn/detail",
        meta: {
          title: "详情",
          hideInMenu: true,
          showbr: true
        },
        component: () => import("@/view/signIn/detail.vue")
      },
      {
        path: "/signIn/detailActivities",
        meta: {
          title: "详情",
          hideInMenu: true,
          showbr: true
        },
        component: () => import("@/view/signIn/detailActivities.vue")
      }
    ]
  },
  {
    path: "/clockIn",
    name: "clockIn",
    meta: {
      icon: "ios-briefcase",
      title: "早起打卡管理"
    },
    component: Main,
    children: [
      {
        path: "/clockEarly/userList",
        name: "clockEarlyUserList",
        meta: {
          icon: "md-grid",
          title: "用户列表"
        },
        component: () => import("@/view/clockEarly/userList.vue")
      },
      {
        path: "/clockEarly/clockInList",
        name: "clockInList",
        meta: {
          icon: "md-grid",
          title: "早起活动"
        },
        component: () => import("@/view/clockEarly/clockInList.vue")
      },
      {
        path: "/clockEarly/setTabs",
        name: "clockSetTabs",
        meta: {
          icon: "md-grid",
          title: "早起打卡设置"
        },
        component: () => import("@/view/clockEarly/setTabs.vue")
      },
      {
        path: "/clockEarly/photoReview",
        name: "clockPhotoReview",
        meta: {
          icon: "md-grid",
          title: "打卡照片审核"
        },
        component: () => import("@/view/clockEarly/photoReview.vue")
      },
      {
        path: "/clockEarly/dataStatistics",
        name: "clockEarlyDataStatistics",
        meta: {
          hideInMenu: false,
          title: "数据统计",
          icon: "md-grid",
          notCache: true,
          showbr: true
        },
        component: () => import("@/view/clockEarly/dataStatistics.vue")
      },
      {
        path: "/clockEarly/detail",
        meta: {
          title: "详情",
          hideInMenu: true,
          showbr: true
        },
        component: () => import("@/view/clockEarly/detail.vue")
      },
      {
        path: "/clockEarly/userAcDetail",
        meta: {
          title: "详情",
          hideInMenu: true,
          showbr: true
        },
        component: () => import("@/view/clockEarly/userAcDetail.vue")
      }
      // {
      //   path: '/theme',
      //   name: 'theme',
      //   meta: {
      //     icon: 'md-grid',
      //     title: '主题'
      //   },
      //   component: () => import('@/view/cms/theme.vue')
      // },
      // {
      //   path: '/categories',
      //   name: 'categories',
      //   meta: {
      //     icon: 'md-grid',
      //     title: '栏目'
      //   },
      //   component: () => import('@/view/cms/categories.vue')
      // }, {
      //   path: '/course',
      //   name: 'course',
      //   meta: {
      //     icon: 'md-grid',
      //     title: '条目'
      //   },
      //   component: () => import('@/view/cms/course/index.vue')
      // },
      // {
      //   path: '/courseSection',
      //   name: 'courseSection',
      //   meta: {
      //     icon: 'md-grid',
      //     title: '条目板块'
      //   },
      //   component: () => import('@/view/cms/courseSection/index.vue')
      // },
      // {
      //   path: '/courseContent',
      //   name: 'courseContent',
      //   meta: {
      //     icon: 'md-grid',
      //     title: '条目内容'
      //   },
      //   component: () => import('@/view/cms/courseContent/index.vue')
      // }
    ]
  },
  {
    path: "/keyword",
    name: "keyword",
    meta: {
      icon: "ios-briefcase",
      title: "关键词过滤"
    },
    component: Main,
    children: [
      {
        path: "/keywordFiltering",
        name: "keywordFiltering",
        meta: {
          icon: "md-bonfire",
          title: "关键词过滤"
        },
        component: () => import("@/view/clockEarly/keywordFiltering.vue")
      }
    ]
  },
  {
    path: "/admin",
    name: "admin",
    meta: {
        icon: "ios-people",
      title: "权限管理"
    },
    component: Main,
    children: [
      {
        path: "/admin/list",
        name: "adminList",
        meta: {
          title: "管理员列表"
        },
        component: () => import("@/view/admin/list.vue")
      },
      {
        path: "/admin/roleList",
        name: "roleList",
        meta: {
          title: "角色管理"
        },
        component: () => import("@/view/admin/roleList.vue")
      },
      {
        path: "/admin/logList",
        name: "logList",
        meta: {
          title: "操作日志"
        },
        component: () => import("@/view/admin/logList.vue")
      },
      {
        path: "/admin/add",
        meta: {
          title: "新增/编辑管理员",
          hideInMenu: true,
          showbr: true
        },
        component: () => import("@/view/admin/add.vue")
      },
    ]
  }

  // {
  //   path: '/appManager',
  //   name: 'appManager',
  //   meta: {
  //     showAlways: true,
  //     icon: 'ios-briefcase',
  //     title: 'APP管理'
  //   },
  //   component: Main,
  //   children: [
  //     {
  //       path: '/appUpdateManage',
  //       name: 'appUpdateManage',
  //       meta: {
  //         icon: 'md-grid',
  //         title: 'APP更新管理'
  //       },
  //       component: () => import('@/view/appManager/index.vue')
  //     }
  //   ]
  // },
  // {
  //   path: '/materialManager',
  //   name: 'materialManager',
  //   meta: {
  //     icon: 'ios-briefcase',
  //     title: '素材管理'
  //   },
  //   component: Main,
  //   children: [
  //     {
  //       path: '/soundTrack',
  //       name: 'soundTrack',
  //       meta: {
  //         icon: 'md-grid',
  //         title: '音轨'
  //       },
  //       component: () => import('@/view/materialManager/soundTrack.vue')
  //     },
  //     {
  //       path: '/resource',
  //       name: 'resource',
  //       meta: {
  //         icon: 'md-grid',
  //         title: '资源库'
  //       },
  //       component: () => import('@/view/materialManager/resource/index.vue')
  //     },
  //     {
  //       path: '/rings',
  //       name: 'rings',
  //       meta: {
  //         icon: 'md-grid',
  //         title: '铃声'
  //       },
  //       component: () => import('@/view/materialManager/rings/index.vue')
  //     }
  //   ]
  // },
  // {
  //   path: '/advertisingManager',
  //   name: 'advertisingManager',
  //   meta: {
  //     icon: 'ios-briefcase',
  //     title: '广告管理'
  //   },
  //   component: Main,
  //   children: [
  //     {
  //       path: '/advertisement',
  //       name: 'advertisement',
  //       meta: {
  //         icon: 'md-grid',
  //         title: '首页广告'
  //       },
  //       component: () => import('@/view/advertisingManager/advertisement/index.vue')
  //     }
  //   ]
  // },
  // {
  //   path: '/push',
  //   name: 'push',
  //   meta: {
  //     showAlways: true,
  //     icon: 'ios-briefcase',
  //     title: '推送'
  //   },
  //   component: Main,
  //   children: [
  //     {
  //       path: '/messagePush',
  //       name: 'messagePush',
  //       meta: {
  //         icon: 'md-grid',
  //         title: '通知推送'
  //       },
  //       component: () => import('@/view/push/messagePush/index.vue')
  //     }
  //   ]
  // },
  // {
  //   path: '/userCenter',
  //   name: 'userCenter',
  //   meta: {
  //     icon: 'ios-briefcase',
  //     title: '用户中心'
  //   },
  //   component: Main,
  //   children: [
  //     {
  //       path: '/userList',
  //       name: 'userList',
  //       meta: {
  //         icon: 'md-grid',
  //         title: '用户列表'
  //       },
  //       component: () => import('@/view/userCenter/userList/index.vue')
  //     },
  //     {
  //       path: '/userReport',
  //       name: 'userReport',
  //       meta: {
  //         icon: 'md-grid',
  //         title: '用户报告'
  //       },
  //       component: () => import('@/view/userCenter/userReport/index.vue')
  //     },
  //     {
  //       path: '/userReviews',
  //       name: 'userReviews',
  //       meta: {
  //         icon: 'md-grid',
  //         title: '用户评论'
  //       },
  //       component: () => import('@/view/userCenter/userReviews/index.vue')
  //     }
  //   ]
  // },
  // {
  //   path: '/payInvite',
  //   name: 'payInvite',
  //   meta: {
  //     icon: 'ios-briefcase',
  //     title: '支付与邀请'
  //   },
  //   component: Main,
  //   children: [
  //     {
  //       path: '/goods',
  //       name: 'goods',
  //       meta: {
  //         icon: 'md-grid',
  //         title: '商品'
  //       },
  //       component: () => import('@/view/payInvite/goods/index.vue')
  //     },
  //     {
  //       path: '/vipBuy',
  //       name: 'vipBuy',
  //       meta: {
  //         icon: 'md-grid',
  //         title: 'VIP购买页'
  //       },
  //       component: () => import('@/view/payInvite/vipBuy/index.vue')
  //     },
  //     {
  //       path: '/vipMeal',
  //       name: 'vipMeal',
  //       meta: {
  //         icon: 'md-grid',
  //         title: 'VIP购买页套餐'
  //       },
  //       component: () => import('@/view/payInvite/vipMeal/index.vue')
  //     },
  //     {
  //       path: '/payOrder',
  //       name: 'payOrder',
  //       meta: {
  //         icon: 'md-grid',
  //         title: '支付订单'
  //       },
  //       component: () => import('@/view/payInvite/payOrder/index.vue')
  //     },
  //     {
  //       path: '/record',
  //       name: 'record',
  //       meta: {
  //         icon: 'md-grid',
  //         title: '邀请好友记录'
  //       },
  //       component: () => import('@/view/payInvite/record/index.vue')
  //     }
  //   ]
  // },
  // {
  //   path: '/error_logger',
  //   name: 'error_logger',
  //   meta: {
  //     hideInBread: true,
  //     hideInMenu: true
  //   },
  //   component: Main,
  //   children: [
  //     {
  //       path: 'error_logger_page',
  //       name: 'error_logger_page',
  //       meta: {
  //         icon: 'ios-bug',
  //         title: '错误收集'
  //       },
  //       component: () => import('@/view/single-page/error-logger.vue')
  //     }
  //   ]
  // },
  // {
  //   path: '/401',
  //   name: 'error_401',
  //   meta: {
  //     hideInMenu: true
  //   },
  //   component: () => import('@/view/error-page/401.vue')
  // },
  // {
  //   path: '/500',
  //   name: 'error_500',
  //   meta: {
  //     hideInMenu: true
  //   },
  //   component: () => import('@/view/error-page/500.vue')
  // },
  // {
  //   path: '*',
  //   name: 'error_404',
  //   meta: {
  //     hideInMenu: true
  //   },
  //   component: () => import('@/view/error-page/404.vue')
  // }
];
