module.exports = {
  /**
   * Application configuration section
   * http://pm2.keymetrics.io/docs/usage/application-declaration/
   */
  apps: [

    {
      name: 'chongsu_dashboard',
      instances: 1,
      exec_mode: 'cluster',
      env: {
        COMMON_VARIABLE: 'true'
      },
      env_production: {
        NODE_ENV: 'production'
      }
    }
  ],
  deploy: {
    production: {
      user: 'chongsu',
      host: '123.56.237.136',
      ref: 'master',
      repo: 'git@gitee.com:feimantu/chongsu_dashboard.git',
      path: '/home/chongsu/web_code/chongsu_dashboard',
      'pre-setup': '',
      'post-setup': 'ls -la',
      'post-deploy': 'npm install && npm run build'
    }
  }
}
